<?php
/**
 * MCE SearchReplace Buttons
 *
 * @package           MCESearchReplaceButtons
 * 
 * @wordpress-plugin
 * Plugin Name:       MCE SearchReplace Buttons
 * Plugin URI:        https://blog.anton.tokyo/mce-search-replace-buttons
 * Description:       Add <strong>controls for Search and Replace</strong> to the visual content editor with this <strong>light weight</strong> plug-in.
 * Version:           1.0.0
 * Requires at least: 4.0
 * Requires PHP:      
 * Author:            Anton Mashkovtsev
 * Author URI:        https://anton.tokyo/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * MCE SearchReplace Buttons main class.
 */
class MCE_SearchReplace_Buttons {
	/**
	 * Handles initializing this class and returning the singleton instance after it's been cached.
	 *
	 * @return null|MCE_SearchReplace_Buttons
	 */
	public static function get_instance() {
		// Store the instance locally to avoid private static replication.
		static $instance = null;

		if ( null === $instance ) {
			$instance = new self();
			self::setup_plugin();
		}

		return $instance;
	}

	/**
	 * An empty constructor
	 */
	public function __construct() {
		/* Purposely do nothing here. */
	}

	/**
	 * Handles registering hooks that initialize this plugin.
	 */
	public static function setup_plugin() {
		add_filter( 'mce_external_plugins', array( __CLASS__, 'mce_external_plugins' ) );
		add_filter( 'mce_buttons_2', array( __CLASS__, 'mce_buttons_2' ) );
	}

	/**
	 * Initialize TinyMCE searchreplace plugin and custom TinyMCE plugin
	 *
	 * @param array $plugin_array Array of TinyMCE plugins.
	 * @return array Array of TinyMCE plugins
	 */
	public static function mce_external_plugins( $plugin_array ) {
		global $tinymce_version;
		$variant = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

		if ( version_compare( $tinymce_version, '4700', '<' ) ) {

			$plugin_array['searchreplace'] = plugin_dir_url( __FILE__ ) . 'tinymce41-searchreplace/plugin' . $variant . '.js';

		} else {

			$plugin_array['searchreplace'] = plugin_dir_url( __FILE__ ) . 'tinymce47-searchreplace/plugin' . $variant . '.js';

		}

		return $plugin_array;
	}

	/**
	 * Add TinyMCE searchreplace control buttons
	 *
	 * @param array $buttons Buttons for the second row.
	 * @return array Buttons for the second row
	 */
	public static function mce_buttons_2( $buttons ) {
		// in case someone is manipulating other buttons, drop searchreplace controls at the end of the row.
		$pos = array_search( 'undo', $buttons, true );
		if ( ! $pos ) {
			array_push( $buttons, 'searchreplace' );
			return $buttons;
		}

		$buttons = array_merge( array_slice( $buttons, 0, $pos ), array( 'searchreplace' ), array_slice( $buttons, $pos ) );

		return $buttons;
	}
}

MCE_SearchReplace_Buttons::get_instance();
